/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.block;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.block.BlockPeripheral;
import net.montoyo.wd.core.DefaultPeripheral;
import net.montoyo.wd.core.IPeripheral;
import net.montoyo.wd.entity.TileEntityKeyboard;
import net.montoyo.wd.item.ItemLinker;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Vector3i;

public class BlockKeyboardRight
extends Block
implements IPeripheral {
    public static final PropertyInteger facing = PropertyInteger.func_177719_a((String)"facing", (int)0, (int)3);
    private static final IProperty[] properties = new IProperty[]{facing};
    public static final AxisAlignedBB KEYBOARD_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);

    public BlockKeyboardRight() {
        super(Material.field_151576_e);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149663_c("webdisplays.peripheral.keyboard");
        this.setRegistryName("keyboard");
        this.field_149787_q = false;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, properties);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return KEYBOARD_AABB;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)facing, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)facing);
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)WebDisplays.INSTANCE.blockPeripheral, 1, 0);
    }

    private TileEntityKeyboard getTileEntity(World world, BlockPos pos) {
        for (EnumFacing nf : EnumFacing.field_176754_o) {
            BlockPos np = pos.func_177971_a(nf.func_176730_m());
            IBlockState ns = world.func_180495_p(np);
            if (!(ns.func_177230_c() instanceof BlockPeripheral) || ns.func_177229_b(BlockPeripheral.type) != DefaultPeripheral.KEYBOARD) continue;
            TileEntity te = world.func_175625_s(np);
            if (te == null || !(te instanceof TileEntityKeyboard)) break;
            return (TileEntityKeyboard)te;
        }
        return null;
    }

    @Override
    public boolean connect(World world, BlockPos pos, IBlockState state, Vector3i scrPos, BlockSide scrSide) {
        TileEntityKeyboard keyboard = this.getTileEntity(world, pos);
        return keyboard != null && keyboard.connect(world, pos, state, scrPos, scrSide);
    }

    @Nonnull
    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.IGNORE;
    }

    public static boolean checkNeighborhood(IBlockAccess world, BlockPos bp, BlockPos ignore) {
        for (EnumFacing neighbor : EnumFacing.field_176754_o) {
            IBlockState state;
            BlockPos np = bp.func_177971_a(neighbor.func_176730_m());
            if (ignore != null && np.equals((Object)ignore) || !((state = world.func_180495_p(np)).func_177230_c() instanceof BlockPeripheral ? state.func_177229_b(BlockPeripheral.type) == DefaultPeripheral.KEYBOARD : state.func_177230_c() instanceof BlockKeyboardRight)) continue;
            return false;
        }
        return true;
    }

    public void removeLeftPiece(World world, BlockPos pos, boolean dropItem) {
        for (EnumFacing nf : EnumFacing.field_176754_o) {
            BlockPos np = pos.func_177971_a(nf.func_176730_m());
            IBlockState ns = world.func_180495_p(np);
            if (!(ns.func_177230_c() instanceof BlockPeripheral) || ns.func_177229_b(BlockPeripheral.type) != DefaultPeripheral.KEYBOARD) continue;
            if (dropItem) {
                ns.func_177230_c().func_176226_b(world, np, ns, 0);
            }
            world.func_175698_g(np);
            break;
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborType, BlockPos neighbor) {
        if (world.field_72995_K) {
            return;
        }
        if (neighbor.func_177958_n() == pos.func_177958_n() && neighbor.func_177956_o() == pos.func_177956_o() - 1 && neighbor.func_177952_p() == pos.func_177952_p() && world.func_175623_d(neighbor)) {
            this.removeLeftPiece(world, pos, true);
            world.func_175698_g(pos);
        }
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer ply, boolean willHarvest) {
        if (!world.field_72995_K) {
            this.removeLeftPiece(world, pos, !ply.func_184812_l_());
        }
        return super.removedByPlayer(state, world, pos, ply, willHarvest);
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosionIn) {
        if (!world.field_72995_K) {
            this.removeLeftPiece(world, pos, true);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntityKeyboard tek;
        double rpos = (entity.field_70163_u - (double)pos.func_177956_o()) * 16.0;
        if (!world.field_72995_K && rpos >= 1.0 && rpos <= 2.0 && Math.random() < 0.25 && (tek = this.getTileEntity(world, pos)) != null) {
            tek.simulateCat(entity);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        if (player.func_184586_b(hand).func_77973_b() instanceof ItemLinker) {
            return false;
        }
        TileEntityKeyboard tek = this.getTileEntity(world, pos);
        if (tek != null) {
            return tek.onRightClick(player, hand, BlockSide.values()[facing.ordinal()]);
        }
        return false;
    }
}

